#!/bin/bash
# Oletuksena arvotaan 3 sarjaa
times='3'
# Oletuksena 100 heittoa kussakin sarjassa
flips='100'
# Jos komentorivillä on annettu parametrina joku luku, käytetään sitä kertojen määränä.
if [ -n "$1" ]
then
  times="$1"
fi
# Jos komentorivillä on annettu toisena parametrina joku luku, käytetään sitä heittojen määränä.
if [ -n "$2" ]
then
  flips="$2"
fi
# Tulostetaan aluksi vaakaviiva.
echo "-------------------------"
# seq tulostaa luvut 1 ... $times. Suoritetaan silmukka kullakin luvulla.
for i in $(seq $times)
do
  # Suoritetaan $flips kertaa: tulostetaan "kruuna" ja "klaava" (omille riveilleen),
  # järjestetään satunnaisesti ja poimitaan ensimmäinen.
  # Nämä sata poimittua tulostuvat stdout:iin.
  # Silmukan jälkeen (done) tulostus aakkostetaan (kaikki klaavat ensin ja kruunat sitten).
  # Lopuksi tulosteesta uniq-komento laskee peräkkäisten samanlaisten rivien määrät.
  for j in $(seq $flips)
  do
    echo -e "kruuna\nklaava" | sort -R |head -n 1
  done | sort | uniq -c
  # Tulostetaan jokaisen tuloksen perään viiva.
  echo "-------------------------"
done
